﻿program PlatformaIzolacyjna2;

uses
  SysUtils,
  DUnitX.TestFramework,
  DUnitX.Loggers.Console,
  DUnitX.Windows.Console,
  Delphi.Mocks in 'Delphi.Mocks.pas',
  Delphi.Mocks.Behavior in 'Delphi.Mocks.Behavior.pas',
  Delphi.Mocks.Helpers in 'Delphi.Mocks.Helpers.pas',
  Delphi.Mocks.Interfaces in 'Delphi.Mocks.Interfaces.pas',
  Delphi.Mocks.MethodData in 'Delphi.Mocks.MethodData.pas',
  Delphi.Mocks.Utils in 'Delphi.Mocks.Utils.pas',
  Delphi.Mocks.VirtualInterface in 'Delphi.Mocks.VirtualInterface.pas',
  Delphi.Mocks.When in 'Delphi.Mocks.When.pas',
  Delphi.Mocks.Expectation in 'Delphi.Mocks.Expectation.pas',
  Delphi.Mocks.ObjectProxy in 'Delphi.Mocks.ObjectProxy.pas',
  Delphi.Mocks.Proxy in 'Delphi.Mocks.Proxy.pas',
  Delphi.Mocks.VirtualMethodInterceptor in 'Delphi.Mocks.VirtualMethodInterceptor.pas',
  Delphi.Mocks.ReturnTypePatch in 'Delphi.Mocks.pas',
  uWeryfikatorKartKredytowych in 'uWeryfikatorKartKredytowych.pas',
  uSystemObsługiKartKredytowych in 'uSystemObsługiKartKredytowych.pas';

type
  [TestFixture]
  TTestWeryfikatoraKartKredytowych = class
     public
     [Test]
     procedure TestObciążeniaWażnejKarty;
     [Test]
     procedure TestBrakuObciążeniaNieważnejKarty;
  end;

procedure TTestWeryfikatoraKartKredytowych.TestObciążeniaWażnejKarty;
var
  SystemObsługiKartKredytowych: TSystemObsługiKartKredytowych;
  WeryfikatorKartKredytowych: TMock<IWeryfikatorKartKredytowych>;
  WażnaKarta: String;
  WartośćWejściowa: Double;
  WartośćOczekiwana, WartośćRzeczywista: Double;
begin
  // Przygotuj
  WażnaKarta := '123456';
  WartośćWejściowa := 49.95;
  WartośćOczekiwana := WartośćWejściowa;
  WeryfikatorKartKredytowych := TMock<IWeryfikatorKartKredytowych>.Create;
  WeryfikatorKartKredytowych.Setup.WillReturn(True).When.
    CzyKartaJestWażna(WażnaKarta);

  SystemObsługiKartKredytowych := TSystemObsługiKartKredytowych.Create(WeryfikatorKartKredytowych);
  try
    // Wykonaj
    WartośćRzeczywista := SystemObsługiKartKredytowych.PłatnośćKartą(WażnaKarta, WartośćWejściowa)
  finally
    SystemObsługiKartKredytowych.Free;
  end;
  // Sprawdź
  Assert.AreEqual(WartośćOczekiwana, WartośćRzeczywista);
end;

procedure TTestWeryfikatoraKartKredytowych.TestBrakuObciążeniaNieważnejKarty;
var
  SystemObsługiKartKredytowych: TSystemObsługiKartKredytowych;
  WeryfikatorKartKredytowych: TMock<IWeryfikatorKartKredytowych>;
  WażnaKarta: String;
  WartośćWejściowa: Double;
  WartośćOczekiwana, WartośćRzeczywista: Double;
begin
  // Przygotuj
  WażnaKarta := '777777'; // 7 oznacza, że karta jest nieważna
  WartośćWejściowa := 49.95;
  WartośćOczekiwana := 0;
  WeryfikatorKartKredytowych := TMock<IWeryfikatorKartKredytowych>.Create;
  // Informacja dla atrapy, że karta jest nieważna
  WeryfikatorKartKredytowych.Setup.WillReturn(False).When.CzyKartaJestWażna(WażnaKarta);

  SystemObsługiKartKredytowych := TSystemObsługiKartKredytowych.Create(WeryfikatorKartKredytowych);
  try
    // Wykonaj
    WartośćRzeczywista := SystemObsługiKartKredytowych.PłatnośćKartą(WażnaKarta, WartośćWejściowa)
  finally
    SystemObsługiKartKredytowych.Free;
  end;
  // Sprawdź
  Assert.AreEqual(WartośćOczekiwana, WartośćRzeczywista);
end;


var
  Runner: ITestRunner;
  Logger: ITestLogger;
  Results: IRunResults;

begin
  TDUnitX.RegisterTestFixture(TTestWeryfikatoraKartKredytowych);
  try
    // Utworzenie zmiennej testowej
    Runner := TDUnitX.CreateRunner;
    Runner.UseRTTI := True;
    // Wskazanie sposobu rejestrowania wyników testów
    Logger := TDUnitXConsoleLogger.Create;
    Runner.AddLogger(Logger);
    // Wykonanie testów
    Results := Runner.Execute;
    System.Write('Koniec. Naciśnij <Enter> aby zakończyć.');
    System.Readln;
  except
    on E: Exception do
      System.Writeln(E.ClassName, ': ', E.Message);
  end;
end.
